﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BeginAcceptTest001.Client
{
    class Client
    {
        private enum ipKind
        {
            IpV4, IpV6
        }

        static void Main(string[] args)
        {
            // 文字コードを UTF-8 とする
            var enc = System.Text.Encoding.UTF8;

            // サーバーのIPアドレスとポート番号
            var ipv4 = "192.168.1.3";
            var ipv6 = "fe80::[インターフェースID]";
            int portNo = 2001;
            ipKind selectIp;

            if (args.Length != 1)
            {
                Console.WriteLine("引数の数を誤っています。");
                return;
            }
            switch (args[0].ToLower())
            {
                case "ipv4":
                    selectIp = ipKind.IpV4;
                    break;
                case "ipv6":
                    selectIp = ipKind.IpV6;
                    break;
                default:
                    Console.WriteLine("引数が誤っています。引数は ipv4 または ipv6 のみ有効です。");
                    return;
            }

            // TcpClient を作成し、サーバーと接続する
            var isSuccessClient = false;
            System.Net.Sockets.TcpClient client = null;
            try
            {
                if (selectIp == ipKind.IpV6)
                {
                    var ipv6Address = System.Net.IPAddress.Parse(ipv6);
                    client = new System.Net.Sockets.TcpClient(System.Net.Sockets.AddressFamily.InterNetworkV6);
                    client.Connect(ipv6Address, portNo);
                    Console.WriteLine("{0} サーバー({1} Port[{2}])と接続しました。",
                        DateTime.Now.ToString(), ipv6Address.ToString(), portNo);
                    isSuccessClient = true;

                    doProcess(client, enc);
                }
                else
                {
                    var ipv4Address = System.Net.IPAddress.Parse(ipv4);
                    client = new System.Net.Sockets.TcpClient(System.Net.Sockets.AddressFamily.InterNetwork);
                    client.Connect(ipv4Address, portNo);
                    Console.WriteLine("{0} サーバー({1} Port[{2}])と接続しました。",
                        DateTime.Now.ToString(), ipv4Address.ToString(), portNo);
                    isSuccessClient = true;

                    doProcess(client, enc);
                }
            }
            catch (System.Net.Sockets.SocketException e)
            {
                switch (e.ErrorCode)
                {
                    case 10061:
                        Console.WriteLine("{0} サーバーへの接続が拒否されました。", DateTime.Now.ToString());
                        break;
                    default:
                        Console.WriteLine("{0} ソケットエラー コード: {1}", DateTime.Now.ToString(), e.ErrorCode);
                        break;
                }
            }
            catch (System.IO.IOException e)
            {
                if (e.InnerException.GetType() == typeof(System.Net.Sockets.SocketException))
                {
                    switch ((e.InnerException as System.Net.Sockets.SocketException).ErrorCode)
                    {
                        case 10053:
                            Console.WriteLine("{0} サーバーとの接続がサーバー側のタイムアウトにより切断されました。",
                                DateTime.Now.ToString());
                            break;
                        case 10054:
                            Console.WriteLine("{0} サーバーとの接続がサーバー側で強制切断されました。",
                                DateTime.Now.ToString());
                            break;
                        default:
                            Console.WriteLine("{0} ソケットエラー コード: {1}",
                                DateTime.Now.ToString(),
                                (e.InnerException as System.Net.Sockets.SocketException).ErrorCode);
                            break;
                    }
                }
                else
                    throw;
            }
            catch (ConnectionCloseException)
            {
                Console.WriteLine("サーバーからの受信待ち中にサーバーが切断しました");
            }
            finally
            {
                if (isSuccessClient)
                {
                    client.Close();
                    Console.WriteLine("{0} 切断しました。", DateTime.Now.ToString());
                }
            }
        }

        static void doProcess(System.Net.Sockets.TcpClient client, System.Text.Encoding enc)
        {
            // ネットワークストリームを取得する
            using (var stream = client.GetStream())
            {
                var welcome = receiveData(stream, enc);

                var sendString = "abc0123あいうえお";
                sendData(stream, sendString, enc);

                var receiveString = receiveData(stream, enc);

                stream.Close();
            }
        }

        static string receiveData(System.IO.Stream stream, System.Text.Encoding enc)
        {
            var receiveMessage = "";
            using (var memStream = new System.IO.MemoryStream())
            {
                var rBuf = new byte[256];
                int rSize;
                do
                {
                    // データの一部を受信する
                    rSize = stream.Read(rBuf, 0, rBuf.Length);
                    // rSize が 0 のときにはサーバーが切断したと判断
                    if (rSize == 0)
                    {
                        Console.WriteLine("{0} サーバーが切断しました。", DateTime.Now.ToString());
                        throw new ConnectionCloseException("ストリームの読み出しの際、サーバーが切断していました。");
                    }
                    // 受信したデータを蓄積する
                    memStream.Write(rBuf, 0, rSize);
                } while ((stream as System.Net.Sockets.NetworkStream).DataAvailable);

                // 受信したデータを文字列に変換
                receiveMessage = enc.GetString(memStream.ToArray());
                memStream.Close();
            }

            Console.WriteLine("{0} [S] {1}", DateTime.Now.ToString() , receiveMessage);
            return receiveMessage;
        }

        static void sendData(System.IO.Stream stream, string str, System.Text.Encoding enc)
        {
            // 文字列をバイト配列へ
            var data = enc.GetBytes(str);
            stream.Write(data, 0, data.Length);
            Console.WriteLine("{0} [C] {1}", DateTime.Now.ToString(), str);
        }
    }
}
