﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace CommandLeakTest
{
    /// <summary>
    /// WindowUseCommand.xaml の相互作用ロジック
    /// </summary>
    public partial class UseCommandModelessWindow : Window
    {
        private readonly int _geneTimes;

        public UseCommandModelessWindow(int geneTimes)
        {
            InitializeComponent();

            _geneTimes = geneTimes;
            this.DataContext = new UseCommandModellessWindowViewModel(_geneTimes);
            NoticeInfo.DebugWriteLine("Window 生成: UseCommandModelessWindow " +
                _geneTimes.ToString() + "回目");
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            (this.Owner as MainWindow).ClearWindowUseCommand(this);
        }

        ~UseCommandModelessWindow()
        {
            NoticeInfo.DebugWriteLine("Window デストラクタ起動: " +
                _geneTimes.ToString() + "回目に生成された UseCommandModelessWindow");
        }
    }
}
