﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CommandLeakTest
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        private List<WindowUseEventClick> _windowUseEventClicks = new List<WindowUseEventClick>();
        private List<UseCommandModelessWindow> _windowUseCommands = new List<UseCommandModelessWindow>();
        private int _windowUseCommandGeneTimes = 0;

        public MainWindow()
        {
            InitializeComponent();
        }

        public void ClearWindowUseEventClick(WindowUseEventClick window)
        {
            _windowUseEventClicks.Remove(window);
        }

        public void ClearWindowUseCommand(UseCommandModelessWindow window)
        {
            _windowUseCommands.Remove(window);
        }

        private void BtnDoGc_Click(object sender, RoutedEventArgs e)
        {
            NoticeInfo.DebugWriteLine("== GC を実施します。 ==");
            GC.Collect();
            GC.WaitForPendingFinalizers();
            GC.Collect();
        }

        private void BtnOpenClickEventWindow_Click(object sender, RoutedEventArgs e)
        {
            var window  = new WindowUseEventClick();
            window.Owner = this;
            window.Show();
            _windowUseEventClicks.Add(window);
        }

        private void BtnCloseClickEventWindow_Click(object sender, RoutedEventArgs e)
        {
            if (_windowUseEventClicks.Count == 0) return;

            var windows = new List<WindowUseEventClick>();
            _windowUseEventClicks.ForEach(n => windows.Add(n));
            windows.ForEach(n => n.Close());
        }

        private void BtnOpenUseCommandModelessWindow_Click(object sender, RoutedEventArgs e)
        {
            var window = new UseCommandModelessWindow(++_windowUseCommandGeneTimes);
            window.Owner = this;
            window.Show();
            _windowUseCommands.Add(window);
        }

        private void BtnCloseUseCommandModelessWindow_Click(object sender, RoutedEventArgs e)
        {
            if (_windowUseCommands.Count == 0) return;

            var windows = new List<UseCommandModelessWindow>();
            _windowUseCommands.ForEach(n => windows.Add(n));
            windows.ForEach(n => n.Close());
        }


        private void BtnOpenUseCommandModalWindow_Click(object sender, RoutedEventArgs e)
        {
            var window = new UseCommandModalWindow();
            window.Owner = this;
            window.ShowDialog();

            if (window.DialogResult == true)
            {
                MessageBox.Show("OK ボタンがクリックされました。");
            }
            else
            {
                MessageBox.Show("Cancel ボタンがクリックされました。");
            }
        }
    }
}
