﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Windows;
using System.Windows.Input;

namespace CommandLeakTest
{
    class UseCommandModalWindowViewModel : INotifyPropertyChanged
    {
        private Window _view;

        public UseCommandModalWindowViewModel(Window view)
        {
            _view = view;

            NoticeInfo.DebugWriteLine("ViewModel 生成: UseCommandModalWindowViewModel ");
        }

        private ICommand _someCommand;

        public ICommand SomeCommand
        {
            get
            {
                if (_someCommand == null)
                    _someCommand = new RelayCommand(
                        param => SomeCommandExecute()
                        );
                return _someCommand;
            }
        }

        private void SomeCommandExecute()
        {
            NoticeInfo.DebugWriteLine("ボタンがクリックされました。");
            _view.DialogResult = true;
        }

        #region INotifyPropertyChanged Members

        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string propertyName)
        {
            var handler = PropertyChanged;
            if (handler != null)
                handler(this, new PropertyChangedEventArgs(propertyName));
        }

        #endregion // INotifyPropertyChanged Members

        ~UseCommandModalWindowViewModel()
        {
            NoticeInfo.DebugWriteLine("ViewModel デストラクタ起動: UseCommandModalWindowViewModel");
        }
    }
}
