﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Windows.Input;

namespace CommandLeakTest
{
    class UseCommandModellessWindowViewModel : INotifyPropertyChanged
    {
        private int _geneTimes;
        private bool _editCoomandCanExecute = true;
        private bool _someCoomandCanExecute = true;

        public UseCommandModellessWindowViewModel(int geneTimes)
        {
            _geneTimes = geneTimes;

            NoticeInfo.DebugWriteLine("ViewModel 生成: UseCommandModelessWindowViewModel " + 
                _geneTimes.ToString() + "回目");
        }

        private ICommand _editCommand;

        public ICommand EditCommand
        {
            get
            {
                if (_editCommand == null)
                    _editCommand = new RelayCommand(
                        param => EditCommandExecute(),
                        param => EditCommandCanExecute
                        );
                return _editCommand;
            }
        }

        private void EditCommandExecute()
        {
            NoticeInfo.DebugWriteLine("編集メニューがクリックされました。");
        }

        private bool EditCommandCanExecute
        {
            get { return _editCoomandCanExecute; }
        }

        private ICommand _someCommand;

        public ICommand SomeCommand
        {
            get
            {
                if (_someCommand == null)
                    _someCommand = new RelayCommand(
                        param => SomeCommandExecute(),
                        param => SomeCommandCanExecute
                        );
                return _someCommand;
            }
        }

        private void SomeCommandExecute()
        {
            _someCoomandCanExecute = false;
            NoticeInfo.DebugWriteLine("ボタンがクリックされました。");
        }

        private bool SomeCommandCanExecute
        {
            get { return _someCoomandCanExecute; }
        }

        #region INotifyPropertyChanged Members

        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string propertyName)
        {
            var handler = PropertyChanged;
            if (handler != null)
                handler(this, new PropertyChangedEventArgs(propertyName));
        }

        #endregion // INotifyPropertyChanged Members

        ~UseCommandModellessWindowViewModel()
        {
            NoticeInfo.DebugWriteLine("ViewModel デストラクタ起動: " +
                _geneTimes.ToString() + "回目に生成された UseCommandModelessWindowViewModel");
        }
    }
}
