﻿using System;
using System.Windows.Input;
using MakCraft.ViewModels;

namespace DateTimePicker.ViewModels
{
    public class MainWindowViewModel : ValidationViewModelBase
    {
        private DateTime _dateTime; // DateTimePicker とのデータ交換用
        private DateTime _validatedDateTime;    // 検証済みデータの保持用
        private string _scheduleDateString;

        public MainWindowViewModel()
        {
            _dateTime = DateTime.Now;
        }

        // DateTimePicker とバインド
        public DateTime DateTime
        {
            get { return _dateTime; }
            set
            {
                var propertyName = PropertyHelper.GetName(() => DateTime);
                base.RemoveItemValidationError(propertyName);
                // データ検証を行う場合、バインディングに"ValidatesOnDataErrors=True"を設定する(設定しないとエラーが表示されない)
                if (value < DateTime.Parse("2012/01/01 0:0:0"))
                {
                    base.ViewModelState.AddError(propertyName, "日付は 2012年1月1日以降を指定してください。");
                }
                else
                {
                    _validatedDateTime = value;
                }
                _dateTime = value;
                base.RaisePropertyChanged(PropertyHelper.GetName(() => DateTime));
            }
        }

        public string ScheduleDateString
        {
            get { return _scheduleDateString; }
            set
            {
                _scheduleDateString = value;
                base.RaisePropertyChanged(PropertyHelper.GetName(() => ScheduleDateString));
            }
        }

        private void getDateTimeCommandExecute()
        {
            ScheduleDateString = _validatedDateTime.ToString("yyyy年MM月dd日 HH:mm:ss");
        }
        private ICommand getDateTimeCommand;
        public ICommand GetDateTimeCommand
        {
            get
            {
                if (getDateTimeCommand == null)
                    getDateTimeCommand = new RelayCommand(
                        param => getDateTimeCommandExecute()
                    );
                return getDateTimeCommand;
            }
        }

        private void setCommandExecute()
        {
            DateTime = DateTime.Now;
        }
        private ICommand setCommand;
        public ICommand SetCommand
        {
            get
            {
                if (setCommand == null)
                    setCommand = new RelayCommand(
                        param => setCommandExecute()
                    );
                return setCommand;
            }
        }
    }
}
