﻿using System;
using System.Text;
using System.Threading;

namespace IpV4V6AcceptTest.Server
{
    class Server
    {
        private const string HostAddressIpv4 = "127.0.0.1";
        private const string HostAddressIpv6 = "::1";
        private const int PortNo = 10050;
        private const int ConcurrencyLimit = 2;
        private static readonly Encoding ServerEncoding = Encoding.UTF8;

        static void Main(string[] args)
        {
            var service = new ServerService(ConcurrencyLimit, ServerEncoding);
            service.ThreadExceptionOccurred += onException;
            service.StartService(HostAddressIpv4, HostAddressIpv6, PortNo);

            Console.WriteLine("Enter キー押下で Listen を終了します。");
            Console.ReadLine();
            service.StopService();

            Console.WriteLine("タスクの終了を待ちます。");
            service.WaitTasksEnd(); ;

            Console.WriteLine("Enter キー押下で終了します。");
            Console.ReadLine();
        }

        static void onException(object sender, ThreadExceptionEventArgs e)
        {
            Console.WriteLine("例外が発生しました。: {0}, {1}",
                e.Exception.GetType().Name, e.Exception.Message);
        }
    }
}
