﻿using System;

namespace MultiThreadAcceptTest2.Client
{
    class Client
    {
        static void Main(string[] args)
        {
            // 文字コードを UTF-8 とする
            var enc = System.Text.Encoding.UTF8;

            // サーバーのIPアドレスとポート番号
            var hostName = "localhost";
            int portNo = 10050;

            // TcpClient を作成し、サーバーと接続する
            var isSuccessClient = false;
            System.Net.Sockets.TcpClient client = null;
            try
            {
                client = new System.Net.Sockets.TcpClient(hostName, portNo);
                Console.WriteLine("{0} サーバーと接続しました。", DateTime.Now.ToLongTimeString());
                isSuccessClient = true;

                // ネットワークストリームを取得する
                using (var stream = client.GetStream())
                {
                    var welcome = receiveData(stream, enc);

                    var sendString = "abc0123あいうえお";
                    sendData(stream, sendString, enc);

                    var receiveString = receiveData(stream, enc);

                    stream.Close();
                }
            }
            catch (System.Net.Sockets.SocketException e)
            {
                switch (e.ErrorCode)
                {
                    case 10061:
                        Console.WriteLine("{0} サーバーへの接続が拒否されました。", DateTime.Now.ToLongTimeString());
                        break;
                    default:
                        Console.WriteLine("{0} ソケットエラー コード: {1}", DateTime.Now.ToLongTimeString(), e.ErrorCode);
                        break;
                }
            }
            catch (System.IO.IOException e)
            {
                if (e.InnerException.GetType() == typeof(System.Net.Sockets.SocketException))
                {
                    switch ((e.InnerException as System.Net.Sockets.SocketException).ErrorCode)
                    {
                        case 10053:
                            Console.WriteLine("{0} サーバーとの接続がサーバー側のタイムアウトにより切断されました。",
                                DateTime.Now.ToLongTimeString());
                            break;
                        case 10054:
                            Console.WriteLine("{0} サーバーとの接続がサーバー側で強制切断されました。",
                                DateTime.Now.ToLongTimeString());
                            break;
                        default:
                            Console.WriteLine("{0} ソケットエラー コード: {1}",
                                DateTime.Now.ToLongTimeString(),
                                (e.InnerException as System.Net.Sockets.SocketException).ErrorCode);
                            break;
                    }
                }
                else
                    throw;
            }
            catch (ConnectionCloseException)
            {
                Console.WriteLine("{0} サーバーからの受信待ち中にサーバーが切断しました",
                    DateTime.Now.ToLongTimeString());
            }
            finally
            {
                if (isSuccessClient)
                {
                    client.Close();
                    Console.WriteLine("{0} 切断しました。", DateTime.Now.ToLongTimeString());
                }
            }

            Console.Write("Enter キー押下で終了します。");
            Console.ReadLine();
        }

        static string receiveData(System.IO.Stream stream, System.Text.Encoding enc)
        {
            var receiveMessage = "";
            using (var memStream = new System.IO.MemoryStream())
            {
                var rBuf = new byte[256];
                int rSize;
                do
                {
                    // データの一部を受信する
                    rSize = stream.Read(rBuf, 0, rBuf.Length);
                    // rSize が 0 のときにはサーバーが切断したと判断
                    if (rSize == 0)
                    {
                        Console.WriteLine("{0} サーバーが切断しました。", DateTime.Now.ToLongTimeString());
                        throw new ConnectionCloseException("ストリームの読み出しの際、サーバーが切断していました。");
                    }
                    // 受信したデータを蓄積する
                    memStream.Write(rBuf, 0, rSize);
                } while ((stream as System.Net.Sockets.NetworkStream).DataAvailable);

                // 受信したデータを文字列に変換
                receiveMessage = enc.GetString(memStream.ToArray());
                memStream.Close();
            }

            Console.WriteLine("{0} [S] {1}", DateTime.Now.ToLongTimeString(), receiveMessage);
            return receiveMessage;
        }

        static void sendData(System.IO.Stream stream, string str, System.Text.Encoding enc)
        {
            // 文字列をバイト配列へ
            var data = enc.GetBytes(str);
            stream.Write(data, 0, data.Length);
            Console.WriteLine("{0} [C] {1}", DateTime.Now.ToLongTimeString(), str);
        }
    }
}
