﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MultiThreadAcceptTest.Server
{
    class Server
    {
        // Port 2001 を使用
        // 接続してきたクライアントからデータを受信しする
        // 受信した文字列の長さを返信して、接続を閉じた後、終了する
        //
        // 1. TcpListenerクラスのStartメソッドによりListen（監視）を開始し、接続要求を待機
        // 2. 続いてAcceptTcpClientメソッドにより、クライアントの接続要求を受け入れ
        // 3. AcceptTcpClientメソッドで返されるTcpClientオブジェクトのGetStreamメソッドにより
        //    NetworkStreamを取得し、データの送受信にはこのNetworkStreamを使用

        static void Main(string[] args)
        {
            // 文字コードを UTF-8 とする
            var enc = System.Text.Encoding.UTF8;

            // ローカルアドレスで listen を開始する
            var host = "localhost";
            var port = 2001;

            var service = new ServerService()
            {
                HostName = host,
                PortNo = port,
                Encoding = enc
            };

            service.ServiceStart();

            Console.WriteLine("Enter キー押下で Listen を終了します。");
            Console.ReadLine();

            service.ServiceEnd();
            Console.WriteLine("{0} Listen スレッドの 終了を検知しました。Enter キー押下で終了します。",
                DateTime.Now.ToString());
            Console.ReadLine();
        }
    }
}
