﻿using System;
using System.Collections.Generic;
using System.Linq;
using ValidationTestRoomReservation.Models;

namespace ValidationTestRoomReservation.Repositories
{
    public class RoomRepository : IRoomRepository
    {
        private List<ConferenceRoom> _room;
        private List<Reservation> _reservation;

        public RoomRepository()
        {
            _room = new List<ConferenceRoom>
            {
                new ConferenceRoom
                {
                    Id = 0,
                    Name = "第一会議室",
                    Capacity = 10,
                },
                new ConferenceRoom
                {
                    Id = 1,
                    Name = "第二会議室",
                    Capacity = 20,
                },
                new ConferenceRoom
                {
                    Id = 2,
                    Name = "第三会議室",
                    Capacity = 30,
                },
                new ConferenceRoom
                {
                    Id = 4,
                    Name = "大ホール",
                    Capacity = 1500,
                },
            };
            _reservation = new List<Reservation>
            {
                new Reservation
                {
                    RoomId = 1,
                    Start = DateTime.Parse(DateTime.Now.ToString("yyyy/MM/dd") + " 10:00:00"),
                    End = DateTime.Parse(DateTime.Now.ToString("yyyy/MM/dd") + " 11:30:00"),
                    SubscriberName = "ほげ",
                },
                new Reservation
                {
                    RoomId = 1,
                    Start = DateTime.Parse(DateTime.Now.ToString("yyyy/MM/dd") + " 13:00:00"),
                    End = DateTime.Parse(DateTime.Now.ToString("yyyy/MM/dd") + " 14:30:00"),
                    SubscriberName = "ほげ",
                },
            };
        }

        public IQueryable<ConferenceRoom> FindRoom()
        {
            return _room.AsQueryable();
        }

        public ConferenceRoom GetRoom(int id)
        {
            return _room.Find(w => w.Id == id);
        }

        public IQueryable<Reservation> GetReservationList(int roomId)
        {
            return _reservation
                .AsQueryable()
                .Where(w => w.RoomId == roomId);
        }

        public void AddReservation(Reservation reservation)
        {
            _reservation.Add(reservation);
        }
    }
}
