﻿using System;
using System.Linq;
using ValidationTestRoomReservation.Models;
using ValidationTestRoomReservation.Repositories;

namespace ValidationTestRoomReservation.Services
{
    public class ReserveService : IReserveService
    {
        private IRoomRepository _repository;

        public ReserveService() : this(new RoomRepository()) { }
        public ReserveService(IRoomRepository repository)
        {
            _repository = repository;
        }

        public IQueryable<ConferenceRoom> GetRooms()
        {
            return _repository.FindRoom();
        }

        public IsReservError ReserveRoom(int roomId, DateTime start, DateTime end, string subscriverName)
        {
            if (isReserved(roomId, start, end))
            {
                var conflict = _repository.GetReservationList(roomId)
                    .Where(w => w.Start <= end && start <= w.End)
                    .ToList();
                if (conflict.Where(w => start < w.Start).Count() != 0)
                {
                    return IsReservError.EndTime;
                }
                else if (conflict.Where(w => w.End < end).Count() != 0)
                {
                    return IsReservError.StartTime;
                }
                else
                {
                    return IsReservError.BothTime;
                }
            }

            try
            {
                _repository.AddReservation(new Reservation
                {
                    RoomId = roomId,
                    Start = start,
                    End = end,
                    SubscriberName = subscriverName,
                });
            }
            catch (Exception)
            {
                return IsReservError.Repository;
            }
            return IsReservError.None;
        }

        public IQueryable<Reservation> GetReservations(int roomId)
        {
            return _repository.GetReservationList(roomId);
        }

        public bool IsReservValid(DateTime start, DateTime end)
        {
            return (start < end);
        }

        private bool isReserved(int roomId, DateTime start, DateTime end)
        {
            return (_repository.GetReservationList(roomId)
                .Where(w => w.End >= start && w.Start <= end)
                .Count() != 0);
        }
    }
}
