﻿using System;
using System.ComponentModel.DataAnnotations;
using MakCraft.ViewModels;

namespace ValidationTestRoomReservation.UserControls.ViewModels
{
    public class DateTimePickerViewModel : ValidationViewModelBase
    {
        private string _hour;
        private string _minute;
        private string _second;

        public DateTimePickerViewModel()
        {
            setTime(DateTime.Now);
        }

        // DateTimePicker の依存関係プロパティとのバインドは、コードビハインド側で行なっている
        [Required(ErrorMessage = "この項目は必須項目です。")]
        [Range(0, 23, ErrorMessage = "0 から 23 の数字を入力してください。")]
        public string Hour
        {
            get { return _hour; }
            set
            {
                var propertyName = PropertyHelper.GetName(() => Hour);
                base.RemoveItemValidationError(propertyName);   // 項目編集以前のエラーメッセージをクリア
                _hour = value;
                if (!base.IsPropertyAnnotationError(propertyName))   // Hour のデータ検証を確認
                {
                    base.RaisePropertyChanged(propertyName);
                }
            }
        }

        // DateTimePicker の依存関係プロパティとのバインドは、コードビハインド側で行なっている
        [Required(ErrorMessage = "この項目は必須項目です。")]
        [Range(0, 59, ErrorMessage = "0 から 59 の数字を入力してください。")]
        public string Minute
        {
            get { return _minute; }
            set
            {
                var propertyName = PropertyHelper.GetName(() => Minute);
                base.RemoveItemValidationError(propertyName);
                _minute = value;
                if (!base.IsPropertyAnnotationError(propertyName))  // Minute のデータ検証を確認
                {
                    base.RaisePropertyChanged(propertyName);
                }
            }
        }

        // DateTimePicker の依存関係プロパティとのバインドは、コードビハインド側で行なっている
        [Required(ErrorMessage = "この項目は必須項目です。")]
        [Range(0, 59, ErrorMessage = "0 から 59 の数字を入力してください。")]
        public string Second
        {
            get { return _second; }
            set
            {
                var propertyName = PropertyHelper.GetName(() => Second);
                base.RemoveItemValidationError(propertyName);
                _second = value;
                if (!base.IsPropertyAnnotationError(propertyName))  // Second のデータ検証を確認
                {
                    base.RaisePropertyChanged(propertyName);
                }
            }
        }

        private void setTime(DateTime dateTime)
        {
            Hour = dateTime.ToString("HH");
            Minute = dateTime.ToString("mm");
            Second = dateTime.ToString("ss");
        }
    }
}
