﻿using System;
using System.Linq;
using ValidationTestRoomReservation.Models;

namespace ValidationTestRoomReservation.Services
{
    public interface IReserveService
    {
        IQueryable<ConferenceRoom> GetRooms();

        IsReservError ReserveRoom(int roomId, DateTime start, DateTime end, string subscriverName);

        IQueryable<Reservation> GetReservations(int roomId);

        bool IsReservValid(DateTime start, DateTime end);
    }

    /// <summary>
    /// エラーの有無及びエラー発生の場所を表します。
    /// </summary>
    public enum IsReservError
    {
        None, StartTime, EndTime, BothTime, Repository
    }
}
