﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Input;
using ValidationTestRoomReservation.Models;
using ValidationTestRoomReservation.Services;
using MakCraft.ViewModels;

namespace ValidationTestRoomReservation.ViewModels
{
    public class MainWindowViewModel : ValidationViewModelBase
    {
        private IReserveService _service;
        private int _selectedRow;

        public MainWindowViewModel()
        {
            _service = new ReserveService();
        }
        public MainWindowViewModel(IReserveService service)
        {
            _service = service;
        }

        public IList<ConferenceRoom> Rooms
        {
            get
            { return _service.GetRooms().ToList(); }
        }

        public int SelectedRow
        {
            get { return _selectedRow; }
            set
            {
                _selectedRow = value;
                base.RaisePropertyChanged(PropertyHelper.GetName(() => SelectedRow));
            }
        }

        private void showRoomCommandExecute()
        {
            System.Diagnostics.Debug.WriteLine("showButton clicked! {0}", SelectedRow);
            var reserveWindow = new ReserveWindow();
            (reserveWindow.DataContext as ReserveWindowViewModel).RoomId = Rooms[SelectedRow].Id;
            // 子ウィンドウの Owner プロパティには何もセットしていません。
            // 子ウィンドウの Owner プロパティに親(this)インスタンスをセットするには
            // BlendSDKのSystem.Windows.Interactivity.dllを使用するのが良いが、そういった
            // コードを書くのであれば、Livet 等のフレームワークを利用するほうが良いでしょう。
            var dialogResult = reserveWindow.ShowDialog();
            System.Diagnostics.Debug.WriteLine("ReserveWindows Closed!");
            reserveWindow = null;
        }
        private bool showRoomCommandCanExecute
        {
            get { return (SelectedRow > -1); }
        }
        private ICommand showRoomCommand;
        public ICommand ShowRoomCommand
        {
            get
            {
                if (showRoomCommand == null)
                    showRoomCommand = new RelayCommand(
                        param => showRoomCommandExecute(),
                        param => showRoomCommandCanExecute
                    );
                return showRoomCommand;
            }
        }

        private void gcCommandExecute()
        {
            GC.Collect();
            GC.WaitForPendingFinalizers();
            GC.Collect();
        }
        private ICommand gcCommand;
        public ICommand GcCommand
        {
            get
            {
                if (gcCommand == null)
                    gcCommand = new RelayCommand(
                        param => gcCommandExecute()
                    );
                return gcCommand;
            }
        }

    }
}
