﻿using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace Clutch.Behaviors
{
    /// <summary>
    /// プレースホルダを表示する添付プロパティ
    /// </summary>
    class PlaceHolderBehavior : DependencyObject
    {
        public static readonly DependencyProperty PlaceHolderTextProperty =
            DependencyProperty.RegisterAttached(
            "PlaceHolderText",
            typeof(string),
            typeof(PlaceHolderBehavior),
            new PropertyMetadata(null, onPlaceHolderChanged));

        public static void SetPlaceHolderText(TextBox textbox, string suggestion)
        {
            textbox.SetValue(PlaceHolderTextProperty, suggestion);
        }

        public static string GetPlaceHolderText(TextBox textbox)
        {
            return (string)textbox.GetValue(PlaceHolderTextProperty);
        }

        private static void onPlaceHolderChanged(DependencyObject sender, DependencyPropertyChangedEventArgs e)
        {
            var control = sender as TextBox;
            if (control == null) return;

            var suggestion = e.NewValue as string;
            var handler = createEventHandler(suggestion);
            if (string.IsNullOrEmpty(suggestion))
            {
                control.TextChanged -= handler;
            }
            else
            {
                control.TextChanged += handler;
                if (string.IsNullOrEmpty(control.Text))
                {
                    control.Background = createVisualBrush(suggestion);
                }
            }
        }

        private static TextChangedEventHandler createEventHandler(string suggestion)
        {
            return (sender, e) =>
            {
                var control = (TextBox)sender;
                if (string.IsNullOrEmpty(control.Text))
                {
                    control.Background = createVisualBrush(suggestion);
                }
                else
                {
                    control.Background = new SolidColorBrush(Colors.Transparent);
                }
            };
        }

        private static VisualBrush createVisualBrush(string suggestion)
        {
            var visual = new TextBlock
            {
                Text = suggestion,
                Foreground = new SolidColorBrush(Colors.Blue),
                Opacity = 0.5,
            };

            return new VisualBrush(visual)
            {
                Stretch = Stretch.None,
                TileMode = TileMode.None,
                AlignmentX = AlignmentX.Center,
                AlignmentY = AlignmentY.Center,
            };
        }
    }
}
