﻿using System;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Interactivity;

namespace GetJpegInfo.Behaviors
{
    class OpenFileDialogAction : TriggerAction<FrameworkElement>
    {
        public static readonly DependencyProperty EnsureReadOnlyProperty =
            DependencyProperty.Register(
            "EnsureReadOnly",
            typeof(Boolean?),
            typeof(OpenFileDialogAction),
            new PropertyMetadata(null));

        public Boolean? EnsureReadOnly
        {
            get { return (Boolean?)GetValue(EnsureReadOnlyProperty); }
            set { SetValue(EnsureReadOnlyProperty, value); }
        }

        public static readonly DependencyProperty IsFolderPickerProperty =
            DependencyProperty.Register(
            "IsFolderPicker",
            typeof(Boolean?),
            typeof(OpenFileDialogAction),
            new PropertyMetadata(null));

        public Boolean? IsFolderPicker
        {
            get { return (Boolean?)GetValue(IsFolderPickerProperty); }
            set { SetValue(IsFolderPickerProperty, value); }
        }

        public static readonly DependencyProperty AllowNonFileSystemItemsProperty =
            DependencyProperty.Register(
            "AllowNonFileSystemItems",
            typeof(Boolean?),
            typeof(OpenFileDialogAction),
            new PropertyMetadata(null));

        public Boolean? AllowNonFileSystemItems
        {
            get { return (Boolean?)GetValue(AllowNonFileSystemItemsProperty); }
            set { SetValue(AllowNonFileSystemItemsProperty, value); }
        }

        public static readonly DependencyProperty MultiselectProperty =
            DependencyProperty.Register(
            "Multiselect",
            typeof(Boolean?),
            typeof(OpenFileDialogAction),
            new PropertyMetadata(null));

        public Boolean? Multiselect
        {
            get { return (Boolean?)GetValue(MultiselectProperty); }
            set { SetValue(MultiselectProperty, value); }
        }

        public static readonly DependencyProperty TitleProperty =
            DependencyProperty.Register(
            "Title",
            typeof(string),
            typeof(OpenFileDialogAction),
            new PropertyMetadata(null));

        public string Title
        {
            get { return (string)GetValue(TitleProperty); }
            set { SetValue(TitleProperty, value); }
        }

        public static readonly DependencyProperty FileNameProperty =
            DependencyProperty.Register(
            "FileName",
            typeof(string),
            typeof(OpenFileDialogAction),
            new PropertyMetadata(null));

        public string FileName
        {
            get { return (string)GetValue(FileNameProperty); }
            set { SetValue(FileNameProperty, value); }
        }

        public static readonly DependencyProperty FileNamesProperty =
            DependencyProperty.Register(
            "FileNames",
            typeof(IEnumerable<string>),
            typeof(OpenFileDialogAction),
            new PropertyMetadata(null));

        public IEnumerable<string> FileNames
        {
            get { return (IEnumerable<string>)GetValue(FileNamesProperty); }
            set { SetValue(FileNamesProperty, value); }
        }

        protected override void Invoke(object parameter)
        {
            var dialog = new Microsoft.Win32.OpenFileDialog();
            dialog.Multiselect = Multiselect ?? false;
            dialog.Title = Title ?? "";

            if (dialog.ShowDialog() == true)
            {
                FileName = dialog.FileName;
                FileNames = dialog.FileNames;
            }
        }
    }
}
