﻿using System.Collections.Generic;

namespace GetJpegInfo.Graphics
{
    /// <summary>
    /// Exif 形式で情報が保存されている TIFF タグ情報の取得・保持の基底クラスです。
    /// </summary>
    public abstract class ExifTags
    {
        public ExifTags() { }

        private List<string> _tagInfos = new List<string>();
        public IReadOnlyCollection<string> TagInfos
        {
            get { return _tagInfos; }
        }

        public abstract void AddTagInfo(TiffTag tagNo, TiffTagData tagData);

        public virtual void AddMessage(string message)
        {
            _tagInfos.Add(message);
        }

        protected string displayTag(TiffTag tag, string tagInfo)
        {
            return string.Format("{0}: {1}", tag, tagInfo);
        }
    }
}
