﻿using System;
using System.Linq;

namespace GetJpegInfo.Graphics
{
    /// <summary>
    /// JPEG Exif 形式の APP1, Exif IFD の情報を取得・保持します。
    /// </summary>
    public class JpegExifInfo : ExifTags
    {
        public JpegExifInfo() { }

        private UInt16 _resolutionUnit;
        public string ResolutionUnit
        {
            get
            {
                return _resolutionUnit != 0 ?
                    base.displayTag(TiffTag.ResolutionUnit, ((ExifResolutionUnit)_resolutionUnit).ToString()) : null;
            }
        }

        private byte[] _exifVersion = null;
        public string ExifVersion
        {
            get
            {
                if (_exifVersion != null)
                {
                    var temp = GraphicsInfoBase.GetStringUntilNull(_exifVersion, 0, (uint)_exifVersion.Length);
                    return base.displayTag(TiffTag.ExifVersion, temp);
                }
                else
                {
                    return null;
                }
            }
        }

        /// <summary>
        /// JPEG サムネイルの SOI へのオフセット
        /// </summary>
        public UInt32 JPEGInterchangeFormat { get; private set; }

        /// <summary>
        /// JPEG サムネイルの長さ
        /// </summary>
        public UInt32 JPEGInterchangeFormatLength { get; private set; }

        public override void AddTagInfo(TiffTag tagNo, TiffTagData tagData)
        {
            switch (tagNo)
            {
                case TiffTag.JPEGInterchangeFormat:
                    JPEGInterchangeFormat = tagData.LongData.First();
                    break;
                case TiffTag.JPEGInterchangeFormatLength:
                    JPEGInterchangeFormatLength = tagData.LongData.First();
                    break;
                case TiffTag.ResolutionUnit:
                    _resolutionUnit = tagData.ShortData.First();
                    break;
                case TiffTag.ExifVersion:
                    _exifVersion = tagData.ByteData;
                    break;
                default:
                    base.AddMessage(string.Format("{0}: {1}", (TiffTag)tagNo, tagData));
                    break;
            }
        }
    }

    public enum ExifResolutionUnit
    {
        inches = 2,
        centimeters = 3,
    }
}
