﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace GetJpegInfo.Graphics
{
    public class TiffTagInfo
    {
        private const int BYTES_PER_PIXEL3 = 3;
        private const int BYTES_PER_PIXEL4 = 4;

        public TiffTagInfo() { }

        public UInt32 ImageWidth { get; private set; }

        public UInt32 ImageHeight { get; private set; }

        public UInt16[] BitsPerSample { get; private set; }

        public PhotometricInterpretationTag PhotometricInterpretation { get; private set; }

        public CompressionTag Compression { get; private set; }

        public UInt16 ColorDepth
        {
            get
            {
                UInt16 result = 0;
                switch (PhotometricInterpretation)
                {
                    case PhotometricInterpretationTag.WhiteIsZero:
                    case PhotometricInterpretationTag.BlackIsZero:
                    case PhotometricInterpretationTag.RGB_Palette:
                        result = BitsPerSample[0];
                        break;
                    case PhotometricInterpretationTag.RGB:
                    case PhotometricInterpretationTag.YCbCr:
                    case PhotometricInterpretationTag.CIELab:
                        if (BitsPerSample.Length == BYTES_PER_PIXEL3)
                        {
                            foreach (var n in BitsPerSample)
                            {
                                result += n;
                            }
                        }
                        else
                        {
                            result = (UInt16)(BitsPerSample[0] * 3);
                        }
                        break;
                    case PhotometricInterpretationTag.CMYK:
                        if (BitsPerSample.Length == BYTES_PER_PIXEL4)
                        {
                            foreach (var n in BitsPerSample)
                            {
                                result += n;
                            }
                        }
                        else
                        {
                            result = (UInt16)(BitsPerSample[0] * 4);
                        }
                        break;
                    case PhotometricInterpretationTag.TransparencyMask:
                        break;
                }

                return result;
            }
        }

        private List<string> _tagInfos = new List<string>();
        public IReadOnlyCollection<string> TagInfos
        {
            get { return _tagInfos; }
        }

        public void AddTagInfo(TiffTag tagNo, TiffTagData tagData)
        {
            switch (tagNo)
            {
                case TiffTag.ImageWidth:
                    ImageWidth = getLongOrShort(tagData, tagData.TagType);
                    break;
                case TiffTag.ImageLength:
                    ImageHeight = getLongOrShort(tagData, tagData.TagType);
                    break;
                case TiffTag.PhotometricInterpretation:
                    PhotometricInterpretation = (PhotometricInterpretationTag)tagData.ShortData.First();
                    break;
                case TiffTag.BitsPerSample:
                    BitsPerSample = tagData.ShortData;
                    break;
                case TiffTag.Compression:
                    Compression = (CompressionTag)tagData.ShortData.First();
                    break;
                default:
                    _tagInfos.Add(string.Format("{0}: {1}", (TiffTag)tagNo, tagData));
                    break;
            }
        }

        public void AddMessage(string message)
        {
            _tagInfos.Add(message);
        }

        private UInt32 getLongOrShort(TiffTagData tagData, TagType tagType)
        {
            UInt32 result = 0;
            if ((TagType)tagType == TagType.LONG)
            {
                result = tagData.LongData.First();
            }
            else
            {
                result = tagData.ShortData.First();
            }
            return result;
        }
    }
}
