﻿using System;
using System.IO;
using System.Windows.Input;

using MakCraft.ViewModels;

using GetJpegInfo.Graphics;
using GetJpegInfo.ViewModels.Container;

namespace GetJpegInfo.ViewModels
{
    class MainViewModel : TransitionViewModelBase
    {
        private bool _jfifThumb = false;
        private bool _exifThumb = false;
        private byte[] _jfifThumbBytes = null;
        private UInt32 _jfifThumbWidth = 0;
        private UInt32 _jfifThumbHeight = 0;
        private byte[] _exifThumbBytes = null;

        private string _fileName;
        public string FileName
        {
            get { return _fileName; }
            set
            {
                _fileName = value;
                base.RaisePropertyChanged(() => FileName);
                getImageInfo(_fileName);
            }
        }

        private string _fileContents;
        public string FileContents
        {
            get { return _fileContents; }
            set
            {
                _fileContents = value;
                base.RaisePropertyChanged(() => FileContents);
            }
        }

        private object _modalKick;
        /// <summary>
        /// モーダルダイアログの表示のキック用
        /// </summary>
        public object ModalKick
        {
            get { return _modalKick; }
            set
            {
                _modalKick = value;
                base.RaisePropertyChanged(() => ModalKick);
            }
        }

        private void displayJfifThumbExecute()
        {
            base.DialogType = typeof(PictureWindow);
            // コンテナにサムネイル イメージの byte 配列を記録
            var container = new ImageContainer("0", this);
            container.StoredType = ImageContainer.ImageType.BITMAP;
            container.ImageBytes = _jfifThumbBytes;
            container.ImageWidth = _jfifThumbWidth;
            container.ImageHeight = _jfifThumbHeight;
            base.CommunicationDialog = container;
            base.DialogActionCallback = dialogResult =>
            {
                if (dialogResult.HasValue && dialogResult.Value)
                {
                    var viewModel = base.ResultViewModel as PictureViewModel;
                }
            };
            ModalKick = new object();
        }
        private bool displayJfifThumbCanExecute(object param)
        {
            return _jfifThumb;
        }
        private ICommand _displayJfifThumbCommand;
        public ICommand DisplayJfifThumbCommand
        {
            get
            {
                if (_displayJfifThumbCommand == null)
                    _displayJfifThumbCommand = new RelayCommand(displayJfifThumbExecute, displayJfifThumbCanExecute);
                return _displayJfifThumbCommand;
            }
        }

        private void displayExifThumbExecute()
        {
            base.DialogType = typeof(PictureWindow);
            // コンテナにサムネイル イメージの byte 配列を記録
            var container = new ImageContainer("0", this);
            container.StoredType = ImageContainer.ImageType.JPEG;
            container.ImageBytes = _exifThumbBytes;
            base.CommunicationDialog = container;
            base.DialogActionCallback = dialogResult =>
            {
                if (dialogResult.HasValue && dialogResult.Value)
                {
                    var viewModel = base.ResultViewModel as PictureViewModel;
                }
            };
            ModalKick = new object();
        }
        private bool displayExifThumbCanExecute(object param)
        {
            return _exifThumb;
        }
        private ICommand _displayExifThumbCommand;
        public ICommand DisplayExifThumbCommand
        {
            get
            {
                if (_displayExifThumbCommand == null)
                    _displayExifThumbCommand = new RelayCommand(displayExifThumbExecute, displayExifThumbCanExecute);
                return _displayExifThumbCommand;
            }
        }

        private void displayAboutExecute()
        {
            base.DialogType = typeof(AboutWindow);
            base.CommunicationDialog = null;
            base.DialogActionCallback = dialogResult =>
            {
                if (dialogResult.HasValue && dialogResult.Value)
                {
                    var viewModel = base.ResultViewModel as AboutViewModel;
                }
            };
            ModalKick = new object();
        }
        private ICommand _displayAboutCommand;
        public ICommand DisplayAboutCommand
        {
            get
            {
                if (_displayAboutCommand == null)
                    _displayAboutCommand = new RelayCommand(displayAboutExecute);
                return _displayAboutCommand;
            }
        }

        private async void getImageInfo(string filePath)
        {
            Mouse.OverrideCursor = Cursors.Wait;
            FileContents = string.Empty;
            resetItem();

            if (!File.Exists(filePath))
            {
                FileContents = "ファイルが見つかりませんでした。";
                Mouse.OverrideCursor = null;
                return;
            }

            try
            {
                var grafhicsInfo = await GraphicsInfoBase.GetGraphicsInfoBase(filePath);
                grafhicsInfo.ImageCheck();
                FileContents = grafhicsInfo.GetMessage();
                _jfifThumb = grafhicsInfo.HasJfifThumbnail;
                _jfifThumbBytes = grafhicsInfo.JfifThumbnail;
                _exifThumb = grafhicsInfo.HasExifThumbnail;
                _exifThumbBytes = grafhicsInfo.ExifThumbnail;
            }
            catch (NotifyException e)
            {
                FileContents = e.Message;
            }
            catch (OutOfRangeException)
            {
                FileContents = "ファイルは画像ファイルではありません。";
            }
            Mouse.OverrideCursor = null;
        }

        private void resetItem()
        {
            _jfifThumb = false;
            _exifThumb = false;
            _jfifThumbBytes = null;
            _jfifThumbWidth = 0;
            _jfifThumbHeight = 0;
            _exifThumbBytes = null;
        }
    }
}
