﻿using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Windows.Media.Imaging;

using MakCraft.ViewModels;

using GetJpegInfo.ViewModels.Container;

namespace GetJpegInfo.ViewModels
{
    class PictureViewModel : ModalViewModelBase
    {
        public PictureViewModel() { }

        private BitmapSource _picturesource = null;
        public BitmapSource PictureSource
        {
            get { return _picturesource; }
            set
            {
                _picturesource = value;
                base.RaisePropertyChanged(() => PictureSource);
            }
        }

        protected override void OnContainerReceived(object container)
        {
            var bytes = ((ImageContainer)container).ImageBytes;
            var storedType = ((ImageContainer)container).StoredType;
            var width = (int)((ImageContainer)container).ImageWidth;
            var height = (int)((ImageContainer)container).ImageHeight;
            if (storedType == ImageContainer.ImageType.JPEG)
            {
                using (var ms = new MemoryStream(bytes))
                {
                    var decoder = new JpegBitmapDecoder(ms, BitmapCreateOptions.None, BitmapCacheOption.OnLoad);
                    PictureSource = decoder.Frames[0];
                }
            }
            else if (storedType == ImageContainer.ImageType.BITMAP)
            {
                using (var image = new Bitmap(width, height))
                {
                    var offset = 0;
                    for (var y = 0; y < height; ++y)
                    {
                        for (var x = 0; x < width; ++x)
                        {
                            image.SetPixel(x, y, Color.FromArgb(bytes[offset++], bytes[offset++], bytes[offset++]));
                        }
                    }
                    using (var ms = new MemoryStream())
                    {
                        image.Save(ms, ImageFormat.Bmp);
                        ms.Position = 0;
                        var decoder = new BmpBitmapDecoder(ms, BitmapCreateOptions.None, BitmapCacheOption.OnLoad);
                        PictureSource = decoder.Frames[0];
                    }
                }
            }

            base.OnContainerReceived(container);
        }
    }
}
