﻿using System;

namespace GetJpegInfo.Graphics
{
    /// <summary>
    /// GIF LogicalScreenDescriptor の情報を取得・保持します。
    /// </summary>
    class GifLogicalScreenInfo
    {
        public GifLogicalScreenInfo(byte[] source, UInt32 offset)
        {
            setData(source, offset);
        }

        public UInt16 LogicalScreenWidth { get; private set; }
        public UInt16 LogicalScreenHeight { get; private set; }
        public int ColorResolution { get; private set; }

        private void setData(byte[] source, UInt32 offset)
        {
            LogicalScreenWidth = GraphicsInfoBase.GetUInt16(source, offset, Endianness.Little);
            offset += GraphicsInfoBase.INT16_OFFSET;
            LogicalScreenHeight = GraphicsInfoBase.GetUInt16(source, offset, Endianness.Little);
            offset += GraphicsInfoBase.INT16_OFFSET;
            var PackedFields = GraphicsInfoBase.GetByte(source, offset);
            var temp = (PackedFields & 0x70) >> 4;
            ColorResolution = (int)Math.Pow(2, temp + 1);
        }
    }
}
