﻿using System;
using System.Runtime.Serialization;

namespace GetJpegInfo.Graphics
{
    [Serializable]
    public class NotifyException : Exception
    {
        public NotifyException() : base() { }
        public NotifyException(string message) : base(message) { }
        public NotifyException(string message, Exception inner) : base(message, inner) { }
        public NotifyException(SerializationInfo info, StreamingContext context) { }
        public NotifyException(string message, ErrorStatus status)
            : base(message)
        {
            _Status = status;
        }

        private ErrorStatus _Status = 0;
        public ErrorStatus Status
        {
            get { return _Status; }
        }
    }

    public enum ErrorStatus
    {
        FileNotFound = 1,
        OverReadRetryLimit,
    }
}
