﻿using System;
using System.Reflection;

using MakCraft.ViewModels;

namespace GetJpegInfo.ViewModels
{
    class AboutViewModel : ModalViewModelBase
    {
        public AboutViewModel()
        {
            var titleAttrb = (AssemblyTitleAttribute)Attribute.GetCustomAttribute(
                Assembly.GetExecutingAssembly(), typeof(AssemblyTitleAttribute));
            Title = titleAttrb.Title;
            var ver = Assembly.GetExecutingAssembly().GetName().Version;
            Version = string.Format("{0}.{1}.{2}", ver.Major, ver.Minor, ver.Revision);
            Copyright = string.Join(Environment.NewLine, copyrights);
        }

        public string Title { get; private set; }

        public string Copyright { get; private set; }

        public string Version { get; private set; }

        private static readonly string[] copyrights = new string[] {
            "Copyright © HAIJIMA, Makoto  2014",
        };
    }
}
