﻿using System.Collections.Generic;
using System.Globalization;
using System.Windows.Data;

namespace Ipv6UniqueLocal
{
    public class CultureResources
    {
        #region Fields

        private static readonly List<CultureInfo> cultures;
        private static ObjectDataProvider provider;

        #endregion // Fields

        #region Constructor

        static CultureResources()
        {
            cultures = new List<CultureInfo>();

            // 言語の選択候補(日本語(日本), 英語(米国))
            cultures.Add(CultureInfo.GetCultureInfo("ja-JP"));
            cultures.Add(CultureInfo.GetCultureInfo("en-US"));
        }

        #endregion // Constructor

        #region Properties

        public static IList<CultureInfo> Cultures
        {
            get { return cultures; }
        }

        /// <summary>
        /// Properties.Resource へのバインディングソースを提供する
        /// </summary>
        public static ObjectDataProvider ResourceProvider
        {
            get
            {
                // キー「Resources」はApp.xaml内で定義
                if (provider == null && System.Windows.Application.Current != null)
                    provider = (ObjectDataProvider)System.Windows.Application.Current.FindResource("Resources");
                return provider;
            }
        }

        #endregion // Properties

        #region Methods

        /// <summary>
        /// ロケール選択されたリソースを返す
        /// </summary>
        /// <returns></returns>
        public Properties.Resources GetResourceInstance()
        {
            return new Properties.Resources();
        }

        /// <summary>
        /// 言語の切り替えメソッド
        /// </summary>
        /// <param name="culture"></param>
        public static void ChangeCulture(CultureInfo culture)
        {
            Properties.Resources.Culture = culture;
            ResourceProvider.Refresh();
        }

        #endregion // Methods
    }
}
