﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using MakCraft.SmtpOverSsl;

namespace SmtpTestApp
{
    /// <summary>
    /// MailMessage.xaml の相互作用ロジック
    /// </summary>
    public partial class MailMessage : Window
    {
        public MailMessage()
        {
            InitializeComponent();
        }

        private void btnSend_Click(object sender, RoutedEventArgs e)
        {
            var mailMessage = new SmtpMailMessage();
            try
            {
                mailMessage.From = new System.Net.Mail.MailAddress(tbxFrom.Text, tbxFromDisplay.Text);
                mailMessage.To = new System.Net.Mail.MailAddress(tbxTo.Text, tbxToDisplay.Text);
                mailMessage.Subject = tbxSubject.Text;
                mailMessage.Body = tbxBody.Text;
            }
            catch (FormatException)
            {
                MessageBox.Show("正しいメールアドレスを指定してください。");
                return;
            }

            try
            {
                SmtpMail.Send(mailMessage);
                MessageBox.Show("メールを送信しました。", "メール送信", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            catch (ApplicationException ex)
            {
                MessageBox.Show("メールが送れませんでした。エラー内容: " + ex.Message,
                    "メール送信エラー", MessageBoxButton.OK, MessageBoxImage.Warning);
            }
            catch (InvalidOperationException ex)
            {
                MessageBox.Show("メール送信に必要な設定が漏れています。エラー内容: " + ex.Message,
                        "メール送信エラー", MessageBoxButton.OK, MessageBoxImage.Warning);
            }
            catch (System.Net.Sockets.SocketException ex)
            {
                MessageBox.Show("サーバーと接続ができませんでした。エラー内容: " + ex.Message,
                        "メール送信エラー", MessageBoxButton.OK, MessageBoxImage.Warning);
            }
            catch (System.Security.Authentication.AuthenticationException ex)
            {
                MessageBox.Show("SSL 接続ができませんでした。エラー内容: " + ex.Message,
                        "メール送信エラー", MessageBoxButton.OK, MessageBoxImage.Warning);
            }
        }

        private void btnClose_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
    }
}
