﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using MakCraft.SmtpOverSsl;

namespace SmtpTestApp
{
    /// <summary>
    /// BaseSetting.xaml の相互作用ロジック
    /// </summary>
    public partial class BaseSetting : Window
    {
        public BaseSetting()
        {
            InitializeComponent();
        }

        private void btnNext_Click(object sender, RoutedEventArgs e)
        {
            SmtpMail.ServerName = tbxServerName.Text;
            int tempPort;
            int.TryParse(tbxServerPort.Text, out tempPort);
            SmtpMail.ServerPort = tempPort;
            SmtpMail.EnableSsl = ckbSsl.IsChecked ?? false;
            SmtpMail.AuthUserName = tbxUserName.Text;
            SmtpMail.AuthPassword = pbxPassword.Password;
            SmtpMail.AuthMethod = Smtp.SmtpAuthMethod.Plain;
            SmtpMail.MailEncoding = "ISO-2022-JP";

            var dialog = new MailMessage();
            dialog.Owner = this;
            dialog.ShowDialog();
        }

        private void btnClose_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
    }
}
