﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace SmtpTestApp
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private void btnSend_Click(object sender, RoutedEventArgs e)
        {
            var encodingName = "ISO-2022-JP";
            var mail = new MakCraft.SmtpOverSsl.SmtpMailMessage {
                From = new System.Net.Mail.MailAddress(tbxFromAddress.Text, tbxFromName.Text),
                To = new System.Net.Mail.MailAddress(tbxToAddress.Text, tbxToName.Text),
                Subject = tbxSubject.Text,
                Body = tbxBody.Text
            };
            int serverPort;
            int.TryParse(tbxPort.Text, out serverPort);
            var smtp = new MakCraft.SmtpOverSsl.Smtp
            {
                ServerName = tbxServerName.Text,
                ServerPort = serverPort,
                EnableSsl = (ckbEnableSsl.IsChecked == true) ,
                AuthUserName = tbxUserName.Text,
                AuthPassword = pbxPassword.Password,
                AuthMethod = MakCraft.SmtpOverSsl.Smtp.SmtpAuthMethod.Plain,
                MailEncoding = encodingName
            };

            try
            {
                smtp.Send(mail);
                MessageBox.Show("メールを送信しました。", "メール送信", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            catch (ApplicationException ex)
            {
                MessageBox.Show("メールが送れませんでした。エラー内容: " + ex.Message,
                    "メール送信エラー", MessageBoxButton.OK, MessageBoxImage.Warning);
            }
            catch (InvalidOperationException ex)
            {
                MessageBox.Show("メール送信に必要な設定が漏れています。エラー内容: " + ex.Message,
                        "メール送信エラー", MessageBoxButton.OK, MessageBoxImage.Warning);
            }
            catch (System.Net.Sockets.SocketException ex)
            {
                MessageBox.Show("サーバーと接続ができませんでした。エラー内容: " + ex.Message,
                        "メール送信エラー", MessageBoxButton.OK, MessageBoxImage.Warning);
            }
            catch (System.Security.Authentication.AuthenticationException ex)
            {
                MessageBox.Show("SSL 接続ができませんでした。エラー内容: " + ex.Message,
                        "メール送信エラー", MessageBoxButton.OK, MessageBoxImage.Warning);
            }
        }

        private void btnTestWrap_Click(object sender, RoutedEventArgs e)
        {
            var dialog = new BaseSetting();
            dialog.Owner = this;
            dialog.ShowDialog();
        }
    }
}
